/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.MageObject;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.ExileTargetEffect;
import mage.cards.Card;
import mage.cards.a.AbstruseAppropriationAsThoughEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.util.CardUtil;

class AbstruseAppropriationEffect
extends OneShotEffect {
    AbstruseAppropriationEffect() {
        super(Outcome.Exile);
        this.staticText = "Exile target nonland permanent. You may cast that card for as long as it remains exiled, and you may spend colorless mana as though it were mana of any color to cast that spell";
    }

    private AbstruseAppropriationEffect(AbstruseAppropriationEffect effect) {
        super((OneShotEffect)effect);
    }

    public AbstruseAppropriationEffect copy() {
        return new AbstruseAppropriationEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (permanent == null) {
            return false;
        }
        new ExileTargetEffect().setToSourceExileZone(true).setTargetPointer(this.getTargetPointer().copy()).apply(game, source);
        game.processAction();
        Card card = game.getCard(this.getTargetPointer().getFirst(game, source));
        if (card == null || !game.getState().getZone(card.getId()).equals((Object)Zone.EXILED)) {
            return true;
        }
        card = card.getMainCard();
        CardUtil.makeCardPlayable((Game)game, (Ability)source, (Card)card, (boolean)true, (Duration)Duration.Custom, (boolean)false);
        game.addEffect((ContinuousEffect)new AbstruseAppropriationAsThoughEffect(new MageObjectReference((MageObject)card, game)), source);
        return true;
    }
}

