/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.dynamicvalue.common.GetXValue;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.ReturnFromGraveyardToBattlefieldTargetEffect;
import mage.cards.a.AbuelosAwakeningContinuousEffect;
import mage.counters.Counter;
import mage.counters.CounterType;
import mage.counters.Counters;
import mage.game.Game;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class AbuelosAwakeningEffect
extends ReturnFromGraveyardToBattlefieldTargetEffect {
    AbuelosAwakeningEffect() {
        this.staticText = "return target artifact or non-Aura enchantment card from your graveyard to the battlefield with X additional +1/+1 counters on it. It's a 1/1 Spirit creature with flying in addition to its other types";
    }

    private AbuelosAwakeningEffect(AbuelosAwakeningEffect effect) {
        super((ReturnFromGraveyardToBattlefieldTargetEffect)effect);
    }

    public AbuelosAwakeningEffect copy() {
        return new AbuelosAwakeningEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        int counterAmount = GetXValue.instance.calculate(game, source, (Effect)this);
        for (UUID targetId : this.getTargetPointer().getTargets(game, source)) {
            AbuelosAwakeningContinuousEffect continuousEffect = new AbuelosAwakeningContinuousEffect();
            continuousEffect.setTargetPointer((TargetPointer)new FixedTarget(targetId, game));
            game.addEffect((ContinuousEffect)continuousEffect, source);
            if (counterAmount <= 0) continue;
            game.setEnterWithCounters(targetId, new Counters(new Counter[0]).addCounter(CounterType.P1P1.createInstance(counterAmount)));
        }
        return super.apply(game, source);
    }
}

