/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.common.ActivateAsSorceryActivatedAbility;
import mage.abilities.common.EntersBattlefieldTriggeredAbility;
import mage.abilities.costs.Cost;
import mage.abilities.costs.common.SacrificeSourceCost;
import mage.abilities.costs.common.TapSourceCost;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.dynamicvalue.common.GreatestAmongPermanentsValue;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.search.SearchLibraryPutInHandEffect;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.cards.a.AbzanMonumentEffect;
import mage.constants.CardType;
import mage.constants.SubType;
import mage.constants.SuperType;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.target.common.TargetCardInLibrary;

public final class AbzanMonument
extends CardImpl {
    private static final FilterCard filter = new FilterCard("a basic Plains, Swamp, or Forest card");

    public AbzanMonument(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.ARTIFACT}, "{2}");
        this.addAbility((Ability)new EntersBattlefieldTriggeredAbility((Effect)new SearchLibraryPutInHandEffect(new TargetCardInLibrary(filter), true)));
        ActivateAsSorceryActivatedAbility ability = new ActivateAsSorceryActivatedAbility((Effect)new AbzanMonumentEffect(), (Cost)new ManaCostsImpl("{1}{W}{B}{G}"));
        ability.addCost((Cost)new TapSourceCost());
        ability.addCost((Cost)new SacrificeSourceCost());
        this.addAbility(ability.addHint(GreatestAmongPermanentsValue.TOUGHNESS_CONTROLLED_CREATURES.getHint()));
    }

    private AbzanMonument(AbzanMonument card) {
        super((CardImpl)card);
    }

    public AbzanMonument copy() {
        return new AbzanMonument(this);
    }

    static {
        filter.add((Predicate)SuperType.BASIC.getPredicate());
        filter.add(Predicates.or((Predicate[])new Predicate[]{SubType.PLAINS.getPredicate(), SubType.SWAMP.getPredicate(), SubType.FOREST.getPredicate()}));
    }
}

