/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.permanent.token.ZombieToken;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetSacrifice;

class AcererakTheArchlichEffect
extends OneShotEffect {
    AcererakTheArchlichEffect() {
        super(Outcome.Benefit);
        this.staticText = "for each opponent, you create a 2/2 black Zombie creature token unless that player sacrifices a creature of their choice";
    }

    private AcererakTheArchlichEffect(AcererakTheArchlichEffect effect) {
        super((OneShotEffect)effect);
    }

    public AcererakTheArchlichEffect copy() {
        return new AcererakTheArchlichEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        int tokens = 0;
        for (UUID playerId : game.getOpponents(source.getControllerId())) {
            ++tokens;
            Player player = game.getPlayer(playerId);
            if (player == null) continue;
            TargetSacrifice target = new TargetSacrifice(0, 1, (FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURE);
            player.choose(Outcome.Sacrifice, (Target)target, source, game);
            Permanent permanent = game.getPermanent(target.getFirstTarget());
            if (permanent == null || !permanent.sacrifice(source, game)) continue;
            --tokens;
        }
        if (tokens > 0) {
            new ZombieToken().putOntoBattlefield(tokens, game, source, source.getControllerId());
        }
        return true;
    }
}

