/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import java.util.List;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class AcidicSoilEffect
extends OneShotEffect {
    AcidicSoilEffect() {
        super(Outcome.Damage);
        this.staticText = "{this} deals damage to each player equal to the number of lands they control";
    }

    private AcidicSoilEffect(AcidicSoilEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        List permanents = game.getBattlefield().getActivePermanents((FilterPermanent)StaticFilters.FILTER_LAND, source.getControllerId(), source, game);
        for (UUID playerId : game.getState().getPlayersInRange(source.getControllerId(), game)) {
            Player player = game.getPlayer(playerId);
            if (player == null) continue;
            int amount = 0;
            for (Permanent permanent : permanents) {
                if (!permanent.isControlledBy(playerId)) continue;
                ++amount;
            }
            if (amount <= 0) continue;
            player.damage(amount, source.getSourceId(), source, game);
        }
        return true;
    }

    public AcidicSoilEffect copy() {
        return new AcidicSoilEffect(this);
    }
}

