/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.players.Player;
import mage.target.common.TargetCardInLibrary;

class AcquireEffect
extends OneShotEffect {
    private static final FilterCard filter = new FilterCard("an artifact card");

    public AcquireEffect() {
        super(Outcome.PutCardInPlay);
        this.staticText = "Search target opponent's library for an artifact card and put that card onto the battlefield under your control. Then that player shuffles";
    }

    private AcquireEffect(AcquireEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player opponent = game.getPlayer(source.getFirstTarget());
        Player controller = game.getPlayer(source.getControllerId());
        if (opponent != null && controller != null) {
            TargetCardInLibrary target = new TargetCardInLibrary(filter);
            controller.searchLibrary(target, source, game, opponent.getId());
            Card targetCard = game.getCard(target.getFirstTarget());
            if (targetCard != null) {
                controller.moveCards(targetCard, Zone.BATTLEFIELD, source, game);
            }
            opponent.shuffleLibrary(source, game);
            return true;
        }
        return false;
    }

    public AcquireEffect copy() {
        return new AcquireEffect(this);
    }

    static {
        filter.add((Predicate)CardType.ARTIFACT.getPredicate());
    }
}

