/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.ExileTargetEffect;
import mage.cards.a.ActOfAuthorityGainControlEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class ActOfAuthorityEffect
extends OneShotEffect {
    ActOfAuthorityEffect() {
        super(Outcome.Exile);
        this.staticText = "you may exile target artifact or enchantment. If you do, its controller gains control of {this}";
    }

    private ActOfAuthorityEffect(ActOfAuthorityEffect effect) {
        super((OneShotEffect)effect);
    }

    public ActOfAuthorityEffect copy() {
        return new ActOfAuthorityEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent targetPermanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (targetPermanent == null) {
            return false;
        }
        ExileTargetEffect exileTargetEffect = new ExileTargetEffect();
        if (!exileTargetEffect.apply(game, source)) {
            return false;
        }
        Permanent sourcePermanent = source.getSourcePermanentIfItStillExists(game);
        if (sourcePermanent == null) {
            return true;
        }
        ActOfAuthorityGainControlEffect effect = new ActOfAuthorityGainControlEffect(Duration.Custom, targetPermanent.getControllerId());
        effect.setTargetPointer((TargetPointer)new FixedTarget(sourcePermanent, game));
        game.addEffect((ContinuousEffect)effect, source);
        return true;
    }
}

