/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.common.DamageTargetEffect;
import mage.abilities.hint.Hint;
import mage.abilities.hint.StaticHint;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.target.Target;
import mage.target.common.TargetAnyTarget;

class AetherRevoltTriggeredAbility
extends TriggeredAbilityImpl {
    AetherRevoltTriggeredAbility() {
        super(Zone.BATTLEFIELD, null, false);
        this.addTarget((Target)new TargetAnyTarget());
    }

    private AetherRevoltTriggeredAbility(AetherRevoltTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public AetherRevoltTriggeredAbility copy() {
        return new AetherRevoltTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.COUNTERS_ADDED;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        if (!event.getData().equals(CounterType.ENERGY.getName()) || !this.getControllerId().equals(event.getTargetId())) {
            return false;
        }
        int amount = event.getAmount();
        if (amount <= 0) {
            return false;
        }
        this.getEffects().clear();
        this.getEffects().add((Object)new DamageTargetEffect(amount));
        this.getHints().clear();
        this.addHint((Hint)new StaticHint("Energy you got: " + amount));
        return true;
    }

    public String getRule() {
        return "Whenever you get one or more {E}, {this} deals that much damage to any target.";
    }
}

