/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.permanent.PermanentToken;
import mage.players.Player;

class AetherSnapEffect
extends OneShotEffect {
    AetherSnapEffect() {
        super(Outcome.Benefit);
        this.staticText = "Remove all counters from all permanents and exile all tokens";
    }

    private AetherSnapEffect(AetherSnapEffect effect) {
        super((OneShotEffect)effect);
    }

    public AetherSnapEffect copy() {
        return new AetherSnapEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        CardsImpl tokens = new CardsImpl();
        for (Permanent permanent : game.getBattlefield().getActivePermanents(source.getControllerId(), game)) {
            if (permanent instanceof PermanentToken) {
                tokens.add((Card)permanent);
            }
            permanent.removeAllCounters(source, game);
        }
        controller.moveCards((Cards)tokens, Zone.EXILED, source, game);
        return true;
    }
}

