/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DamageTargetEffect;
import mage.cards.Card;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class AetherStingTriggeredAbility
extends TriggeredAbilityImpl {
    public AetherStingTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new DamageTargetEffect(1), false);
    }

    private AetherStingTriggeredAbility(AetherStingTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public AetherStingTriggeredAbility copy() {
        return new AetherStingTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.SPELL_CAST;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Card card;
        if (game.getOpponents(this.controllerId).contains(event.getPlayerId()) && (card = game.getCard(event.getSourceId())) != null && card.isCreature(game)) {
            ((Effect)this.getEffects().get(0)).setTargetPointer((TargetPointer)new FixedTarget(event.getPlayerId()));
            return true;
        }
        return false;
    }

    public String getRule() {
        return "Whenever an opponent casts a creature spell, {this} deals 1 damage to that player.";
    }
}

