/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.ReturnToHandSourceEffect;
import mage.abilities.effects.common.continuous.GainAbilityTargetEffect;
import mage.abilities.triggers.BeginningOfEndStepTriggeredAbility;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.TargetController;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.common.FilterCreatureCard;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.TargetCard;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;
import mage.util.CardUtil;

class AethermagesTouchEffect
extends OneShotEffect {
    AethermagesTouchEffect() {
        super(Outcome.PutCardInPlay);
        this.staticText = "Reveal the top four cards of your library. You may put a creature card from among them onto the battlefield. It gains \"At the beginning of your end step, return this creature to its owner's hand.\" Then put the rest of the cards revealed this way on the bottom of your library in any order";
    }

    private AethermagesTouchEffect(AethermagesTouchEffect effect) {
        super((OneShotEffect)effect);
    }

    public AethermagesTouchEffect copy() {
        return new AethermagesTouchEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        MageObject sourceObject = game.getObject(source);
        if (controller != null && sourceObject != null) {
            CardsImpl cards = new CardsImpl(controller.getLibrary().getTopCards(game, 4));
            if (!cards.isEmpty()) {
                Card card;
                FilterCreatureCard filter = new FilterCreatureCard("a creature card to put onto the battlefield");
                controller.revealCards(sourceObject.getIdName(), (Cards)cards, game);
                TargetCard target = new TargetCard(Zone.LIBRARY, (FilterCard)filter);
                if (cards.count((FilterCard)filter, game) > 0 && controller.choose(this.outcome, (Cards)cards, target, source, game) && (card = game.getCard(target.getFirstTarget())) != null) {
                    Permanent permanent;
                    cards.remove(card);
                    if (controller.moveCards(card, Zone.BATTLEFIELD, source, game) && (permanent = CardUtil.getPermanentFromCardPutToBattlefield((Card)card, (Game)game)) != null) {
                        BeginningOfEndStepTriggeredAbility ability = new BeginningOfEndStepTriggeredAbility(TargetController.YOU, (Effect)new ReturnToHandSourceEffect(true), false, null);
                        GainAbilityTargetEffect effect = new GainAbilityTargetEffect((Ability)ability, Duration.Custom);
                        effect.setTargetPointer((TargetPointer)new FixedTarget(permanent, game));
                        game.addEffect((ContinuousEffect)effect, source);
                    }
                }
                controller.putCardsOnBottomOfLibrary((Cards)cards, game, source, true);
            }
            return true;
        }
        return false;
    }
}

