/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.combat.CombatGroup;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInHand;

class AetherplasmEffect
extends OneShotEffect {
    AetherplasmEffect() {
        super(Outcome.PutCardInPlay);
        this.staticText = "you may put a creature card from your hand onto the battlefield blocking that creature";
    }

    private AetherplasmEffect(AetherplasmEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Card card;
        TargetCardInHand target;
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        if (player.chooseUse(Outcome.PutCardInPlay, "Put a creature card from your hand onto the battlefield?", source, game) && player.choose(Outcome.PutCardInPlay, (Target)(target = new TargetCardInHand((FilterCard)StaticFilters.FILTER_CARD_CREATURE_A)), source, game) && (card = game.getCard(target.getFirstTarget())) != null) {
            Permanent blockedCreature = game.getPermanent(this.getTargetPointer().getFirst(game, source));
            if (player.moveCards(card, Zone.BATTLEFIELD, source, game, false, false, false, null) && game.getCombat() != null && blockedCreature != null) {
                CombatGroup attacker = game.getCombat().findGroup(blockedCreature.getId());
                Permanent putIntoPlay = game.getPermanent(target.getFirstTarget());
                if (putIntoPlay != null && putIntoPlay.isCreature(game) && attacker != null) {
                    game.getCombat().findGroup(blockedCreature.getId()).addBlocker(putIntoPlay.getId(), source.getControllerId(), game);
                }
            }
        }
        return true;
    }

    public AetherplasmEffect copy() {
        return new AetherplasmEffect(this);
    }
}

