/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.abilities.Ability;
import mage.abilities.dynamicvalue.common.PermanentsOnBattlefieldCount;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledPermanent;
import mage.game.Game;
import mage.players.Player;

class AgadeemOccultistEffect
extends OneShotEffect {
    AgadeemOccultistEffect() {
        super(Outcome.GainControl);
        this.staticText = "Put target creature card from an opponent's graveyard onto the battlefield under your control if its mana value is less than or equal to the number of Allies you control";
    }

    private AgadeemOccultistEffect(AgadeemOccultistEffect effect) {
        super((OneShotEffect)effect);
    }

    public AgadeemOccultistEffect copy() {
        return new AgadeemOccultistEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            Card card = game.getCard(source.getFirstTarget());
            if (card != null) {
                int allycount = new PermanentsOnBattlefieldCount((FilterPermanent)new FilterControlledPermanent(SubType.ALLY)).calculate(game, source, (Effect)this);
                if (card.getManaValue() <= allycount) {
                    return controller.moveCards(card, Zone.BATTLEFIELD, source, game);
                }
            }
            return true;
        }
        return false;
    }
}

