/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import java.util.Collection;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.counters.CounterType;
import mage.filter.FilterCard;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.filter.common.FilterControlledCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.game.ExileZone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.util.CardUtil;

class AgathasSoulCauldronAbilityEffect
extends ContinuousEffectImpl {
    private static final FilterPermanent filter = new FilterControlledCreaturePermanent();

    AgathasSoulCauldronAbilityEffect() {
        super(Duration.WhileOnBattlefield, Layer.AbilityAddingRemovingEffects_6, SubLayer.NA, Outcome.AddAbility);
        this.staticText = "creatures you control with +1/+1 counters on them have all activated abilities of all creature cards exiled with {this}";
    }

    private AgathasSoulCauldronAbilityEffect(AgathasSoulCauldronAbilityEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public boolean apply(Game game, Ability source) {
        ExileZone exileZone = game.getExile().getExileZone(CardUtil.getExileZoneId((Game)game, (UUID)source.getSourceId(), (int)game.getState().getZoneChangeCounter(source.getSourceId())));
        if (exileZone == null || exileZone.isEmpty()) {
            return false;
        }
        Set abilities = exileZone.getCards((FilterCard)StaticFilters.FILTER_CARD_CREATURE, game).stream().map(card -> card.getAbilities(game)).flatMap(Collection::stream).filter(Ability::isActivatedAbility).collect(Collectors.toSet());
        if (abilities.isEmpty()) {
            return false;
        }
        for (Permanent permanent : game.getBattlefield().getActivePermanents(filter, source.getControllerId(), source, game)) {
            for (Ability ability : abilities) {
                permanent.addAbility(ability, source.getSourceId(), game, true);
            }
        }
        return true;
    }

    public AgathasSoulCauldronAbilityEffect copy() {
        return new AgathasSoulCauldronAbilityEffect(this);
    }

    static {
        filter.add((Predicate)CounterType.P1P1.getPredicate());
    }
}

