/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import java.util.Collection;
import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.NamePredicate;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;
import mage.target.common.TargetCardAndOrCard;
import mage.target.common.TargetCardAndOrCardInLibrary;
import mage.target.common.TargetCardInLibrary;
import mage.util.CardUtil;

class AgencyOutfitterEffect
extends OneShotEffect {
    private static final String glassName = "Magnifying Glass";
    private static final String capName = "Thinking Cap";

    AgencyOutfitterEffect() {
        super(Outcome.UnboostCreature);
        this.staticText = "you may search your graveyard, hand and/or library for a card named Magnifying Glass and/or a card named Thinking Cap and put them onto the battlefield. If you search your library this way, shuffle.";
    }

    private AgencyOutfitterEffect(AgencyOutfitterEffect effect) {
        super((OneShotEffect)effect);
    }

    public AgencyOutfitterEffect copy() {
        return new AgencyOutfitterEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        Card glassCard = null;
        Card capCard = null;
        if (controller.chooseUse(Outcome.Neutral, "Search your library?", source, game)) {
            TargetCardAndOrCardInLibrary libraryTarget = new TargetCardAndOrCardInLibrary(glassName, capName);
            if (controller.searchLibrary((TargetCardInLibrary)libraryTarget, source, game)) {
                for (UUID id : libraryTarget.getTargets()) {
                    Card card = game.getCard(id);
                    if (card == null) continue;
                    if (CardUtil.haveSameNames((MageObject)card, (String)glassName, (Game)game)) {
                        glassCard = card;
                        continue;
                    }
                    if (!CardUtil.haveSameNames((MageObject)card, (String)capName, (Game)game)) continue;
                    capCard = card;
                }
            }
            controller.shuffleLibrary(source, game);
        }
        if (glassCard == null || capCard == null) {
            FilterCard filter;
            TargetCardAndOrCard target;
            if (glassCard == null && capCard == null) {
                target = new TargetCardAndOrCard(glassName, capName);
                filter = target.getFilter();
            } else {
                String name = glassCard == null ? glassName : capName;
                filter = new FilterCard();
                filter.add((Predicate)new NamePredicate(name));
                target = new TargetCard(0, 1, Zone.ALL, filter);
            }
            target.withNotTarget(true);
            CardsImpl cards = new CardsImpl();
            cards.addAllCards((Collection)controller.getHand().getCards(filter, source.getControllerId(), source, game));
            cards.addAllCards((Collection)controller.getGraveyard().getCards(filter, source.getControllerId(), source, game));
            if (!cards.isEmpty()) {
                controller.choose(this.outcome, (Cards)cards, (TargetCard)target, source, game);
                for (UUID id : target.getTargets()) {
                    Card card = game.getCard(id);
                    if (card == null) continue;
                    if (CardUtil.haveSameNames((MageObject)card, (String)glassName, (Game)game)) {
                        glassCard = card;
                        continue;
                    }
                    if (!CardUtil.haveSameNames((MageObject)card, (String)capName, (Game)game)) continue;
                    capCard = card;
                }
            }
        }
        CardsImpl foundCards = new CardsImpl();
        foundCards.add(glassCard);
        foundCards.add(capCard);
        if (!foundCards.isEmpty()) {
            controller.moveCards((Cards)foundCards, Zone.BATTLEFIELD, source, game);
        }
        return true;
    }
}

