/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import java.util.LinkedHashSet;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.choices.Choice;
import mage.choices.ChoiceImpl;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class AgentToolkitMoveCounterEffect
extends OneShotEffect {
    AgentToolkitMoveCounterEffect() {
        super(Outcome.Benefit);
        this.staticText = "you may move a counter from {this} onto that creature";
    }

    private AgentToolkitMoveCounterEffect(AgentToolkitMoveCounterEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Permanent agentsToolkitPermanent = game.getPermanent(source.getSourceId());
        Player controller = game.getPlayer(source.getControllerId());
        if (agentsToolkitPermanent == null || controller == null) {
            return false;
        }
        Object enteringObject = this.getValue("permanentEnteringBattlefield");
        if (!(enteringObject instanceof Permanent)) {
            return false;
        }
        Permanent enteringCreature = (Permanent)enteringObject;
        LinkedHashSet possibleCounterNames = new LinkedHashSet(agentsToolkitPermanent.getCounters(game).keySet());
        if (possibleCounterNames.isEmpty()) {
            return false;
        }
        ChoiceImpl moveCounterChoice = new ChoiceImpl(false);
        moveCounterChoice.setMessage("Choose counter to move");
        moveCounterChoice.setChoices(possibleCounterNames);
        if (controller.choose(this.outcome, (Choice)moveCounterChoice, game) && possibleCounterNames.contains(moveCounterChoice.getChoice())) {
            String counterName = moveCounterChoice.getChoice();
            CounterType counterType = CounterType.findByName((String)counterName);
            if (counterType == null) {
                return false;
            }
            agentsToolkitPermanent.removeCounters(counterType.getName(), 1, source, game);
            enteringCreature.addCounters(counterType.createInstance(), source, game);
        }
        return true;
    }

    public AgentToolkitMoveCounterEffect copy() {
        return new AgentToolkitMoveCounterEffect(this);
    }
}

