/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

class AidFromTheCowlEffect
extends OneShotEffect {
    AidFromTheCowlEffect() {
        super(Outcome.PutCreatureInPlay);
        this.staticText = "reveal the top card of your library. If it's a permanent card, you may put it onto the battlefield. Otherwise, you may put it on the bottom of your library";
    }

    private AidFromTheCowlEffect(AidFromTheCowlEffect effect) {
        super((OneShotEffect)effect);
    }

    public AidFromTheCowlEffect copy() {
        return new AidFromTheCowlEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null || !controller.getLibrary().hasCards()) {
            return false;
        }
        Card card = controller.getLibrary().getFromTop(game);
        if (card == null) {
            return false;
        }
        controller.revealCards(CardUtil.getSourceIdName((Game)game, (Ability)source), (Cards)new CardsImpl(card), game);
        if (card.isPermanent(game) && controller.chooseUse(Outcome.Neutral, "Put " + card.getIdName() + " onto the battlefield?", source, game)) {
            controller.moveCards(card, Zone.BATTLEFIELD, source, game);
        } else if (controller.chooseUse(Outcome.Neutral, "Put " + card.getIdName() + " on the bottom of your library?", source, game)) {
            controller.putCardsOnBottomOfLibrary(card, game, source);
        } else {
            game.informPlayers(controller.getLogName() + " puts the revealed card back to the top of the library.");
        }
        return true;
    }
}

