/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import java.util.Collection;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.CardType;
import mage.constants.ComparisonType;
import mage.constants.Outcome;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.ManaValuePredicate;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

class AishaOfSparksAndSmokeEffect
extends OneShotEffect {
    AishaOfSparksAndSmokeEffect() {
        super(Outcome.Benefit);
        this.staticText = "you may cast a sorcery spell from your hand with mana value less than or equal to that damage without paying its mana cost";
    }

    private AishaOfSparksAndSmokeEffect(AishaOfSparksAndSmokeEffect effect) {
        super((OneShotEffect)effect);
    }

    public AishaOfSparksAndSmokeEffect copy() {
        return new AishaOfSparksAndSmokeEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null || player.getHand().isEmpty()) {
            return false;
        }
        FilterCard filter = new FilterCard();
        filter.add((Predicate)CardType.SORCERY.getPredicate());
        filter.add((Predicate)new ManaValuePredicate(ComparisonType.FEWER_THAN, 1 + (Integer)this.getValue("damage")));
        return CardUtil.castSpellWithAttributesForFree((Player)player, (Ability)source, (Game)game, (Cards)new CardsImpl((Collection)player.getHand()), (FilterCard)filter);
    }
}

