/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetControlledCreaturePermanent;

class AjaniFellsTheGodsireCounterEffect
extends OneShotEffect {
    AjaniFellsTheGodsireCounterEffect() {
        super(Outcome.Benefit);
        this.staticText = ", then put a vigilance counter on a creature you control";
    }

    private AjaniFellsTheGodsireCounterEffect(AjaniFellsTheGodsireCounterEffect effect) {
        super((OneShotEffect)effect);
    }

    public AjaniFellsTheGodsireCounterEffect copy() {
        return new AjaniFellsTheGodsireCounterEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        TargetControlledCreaturePermanent target = new TargetControlledCreaturePermanent();
        target.withChooseHint("to give a vigilance counter").withNotTarget(true);
        player.choose(this.outcome, (Target)target, source, game);
        Permanent permanent = game.getPermanent(target.getFirstTarget());
        return permanent != null && permanent.addCounters(CounterType.VIGILANCE.createInstance(), source, game);
    }
}

