/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class AkoumFirebirdLandfallAbility
extends TriggeredAbilityImpl {
    public AkoumFirebirdLandfallAbility(Effect effect, boolean optional) {
        this(Zone.GRAVEYARD, effect, optional);
        this.setTriggerPhrase("<i>Landfall</i> &mdash; Whenever a land you control enters, ");
    }

    public AkoumFirebirdLandfallAbility(Zone zone, Effect effect, boolean optional) {
        super(zone, effect, optional);
    }

    private AkoumFirebirdLandfallAbility(AkoumFirebirdLandfallAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ENTERS_THE_BATTLEFIELD;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Permanent permanent = game.getPermanent(event.getTargetId());
        return permanent != null && permanent.isLand(game) && permanent.isControlledBy(this.controllerId);
    }

    public AkoumFirebirdLandfallAbility copy() {
        return new AkoumFirebirdLandfallAbility(this);
    }
}

