/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.cards.a.AkoumHellkiteDamageEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class AkoumHellkiteTriggeredAbility
extends TriggeredAbilityImpl {
    public AkoumHellkiteTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new AkoumHellkiteDamageEffect());
    }

    private AkoumHellkiteTriggeredAbility(AkoumHellkiteTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public AkoumHellkiteTriggeredAbility copy() {
        return new AkoumHellkiteTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ENTERS_THE_BATTLEFIELD;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Permanent permanent = game.getPermanent(event.getTargetId());
        if (permanent == null) {
            return false;
        }
        if (!permanent.isLand(game) || !permanent.isControlledBy(this.getControllerId())) {
            return false;
        }
        Permanent sourcePermanent = game.getPermanent(this.getSourceId());
        if (sourcePermanent == null) {
            return false;
        }
        for (Effect effect : this.getEffects()) {
            if (!(effect instanceof AkoumHellkiteDamageEffect)) continue;
            effect.setTargetPointer((TargetPointer)new FixedTarget(permanent, game));
            return true;
        }
        return false;
    }

    public String getRule() {
        return "<i>Landfall</i> &mdash; Whenever a land you control enters, {this} deals 1 damage to any target. If that land is a Mountain, {this} deals 2 damage instead.";
    }
}

