/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.AddCardTypeTargetEffect;
import mage.abilities.keyword.SaddleAbility;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.game.Game;
import mage.game.permanent.Permanent;

class AlacrianArmoryAnimateEffect
extends OneShotEffect {
    AlacrianArmoryAnimateEffect() {
        super(Outcome.Benefit);
        this.staticText = "choose up to one target Mount or Vehicle you control. Until end of turn, that permanent becomes saddled if it's a Mount and becomes an artifact creature if it's a Vehicle";
    }

    private AlacrianArmoryAnimateEffect(AlacrianArmoryAnimateEffect effect) {
        super((OneShotEffect)effect);
    }

    public AlacrianArmoryAnimateEffect copy() {
        return new AlacrianArmoryAnimateEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent target = game.getPermanent(source.getFirstTarget());
        if (target == null) {
            return false;
        }
        if (target.hasSubtype(SubType.MOUNT, game)) {
            SaddleAbility.applySaddle((Permanent)target, (Game)game);
        }
        if (target.hasSubtype(SubType.VEHICLE, game)) {
            game.addEffect((ContinuousEffect)new AddCardTypeTargetEffect(Duration.EndOfTurn, new CardType[]{CardType.CREATURE, CardType.ARTIFACT}), source);
        }
        return true;
    }
}

