/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.players.Player;
import mage.target.TargetCard;
import mage.util.CardUtil;

class AladdinsLampEffect
extends ReplacementEffectImpl {
    AladdinsLampEffect() {
        super(Duration.EndOfTurn, Outcome.DrawCard);
        this.staticText = "The next time you would draw a card this turn, instead look at the top X cards of your library, put all but one of them on the bottom of your library in a random order, then draw a card. X can't be 0.";
    }

    private AladdinsLampEffect(AladdinsLampEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public AladdinsLampEffect copy() {
        return new AladdinsLampEffect(this);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl(controller.getLibrary().getTopCards(game, ((Integer)CardUtil.getSourceCostsTag((Game)game, (Ability)source, (String)"X", (Object)0)).intValue()));
        controller.lookAtCards(source, null, (Cards)cards, game);
        TargetCard target = new TargetCard(Zone.LIBRARY, new FilterCard("card to stay at the top of library"));
        if (controller.choose(this.outcome, (Cards)cards, target, source, game)) {
            cards.remove((Object)target.getFirstTarget());
        }
        controller.putCardsOnBottomOfLibrary((Cards)cards, game, source, false);
        game.processAction();
        controller.drawCards(1, source, game, event);
        this.discard();
        return true;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DRAW_CARD;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        return source.isControlledBy(event.getPlayerId());
    }
}

