/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.costs.CostImpl;
import mage.game.Game;
import mage.players.Player;

class AlaniaDivergentStormCost
extends CostImpl {
    AlaniaDivergentStormCost() {
        this.text = "have target opponent draw a card";
    }

    private AlaniaDivergentStormCost(AlaniaDivergentStormCost cost) {
        super((CostImpl)cost);
    }

    public boolean canPay(Ability ability, Ability source, UUID controllerId, Game game) {
        Player player = game.getPlayer(controllerId);
        Player opponent = game.getPlayer(source.getFirstTarget());
        return player != null && opponent != null;
    }

    public boolean pay(Ability ability, Game game, Ability source, UUID controllerId, boolean noMana, Cost costToPay) {
        this.paid = false;
        Player opponent = game.getPlayer(source.getFirstTarget());
        if (opponent == null || !opponent.canRespond()) {
            return false;
        }
        this.paid = opponent.drawCards(1, source, game) > 0;
        return this.paid;
    }

    public AlaniaDivergentStormCost copy() {
        return new AlaniaDivergentStormCost(this);
    }
}

