/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import mage.MageObject;
import mage.MageObjectReference;
import mage.constants.CardType;
import mage.constants.SubType;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.stack.Spell;
import mage.watchers.Watcher;

class AlaniaDivergentStormWatcher
extends Watcher {
    private final Map<UUID, MageObjectReference> playerFirstInstantCast = new HashMap<UUID, MageObjectReference>();
    private final Map<UUID, MageObjectReference> playerFirstSorceryCast = new HashMap<UUID, MageObjectReference>();
    private final Map<UUID, MageObjectReference> playerFirstOtterCast = new HashMap<UUID, MageObjectReference>();
    private final Map<UUID, MageObjectReference> playerSecondOtterCast = new HashMap<UUID, MageObjectReference>();

    public AlaniaDivergentStormWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        if (event.getType() != GameEvent.EventType.SPELL_CAST) {
            return;
        }
        Spell spell = (Spell)game.getObject(event.getTargetId());
        if (spell == null) {
            return;
        }
        UUID spellControllerID = spell.getControllerId();
        MageObjectReference spellMOR = new MageObjectReference((MageObject)spell, game);
        if (spell.getCardType(game).contains(CardType.INSTANT)) {
            this.playerFirstInstantCast.putIfAbsent(spellControllerID, spellMOR);
        }
        if (spell.getCardType(game).contains(CardType.SORCERY)) {
            this.playerFirstSorceryCast.putIfAbsent(spellControllerID, spellMOR);
        }
        if (spell.hasSubtype(SubType.OTTER, game)) {
            if (this.playerFirstOtterCast.containsKey(spellControllerID)) {
                this.playerSecondOtterCast.putIfAbsent(spellControllerID, spellMOR);
            }
            this.playerFirstOtterCast.putIfAbsent(spellControllerID, spellMOR);
        }
    }

    public void reset() {
        super.reset();
        this.playerFirstInstantCast.clear();
        this.playerFirstSorceryCast.clear();
        this.playerFirstOtterCast.clear();
        this.playerSecondOtterCast.clear();
    }

    public boolean spellIsFirstISOCast(UUID controllerID, MageObjectReference spell, MageObjectReference AlaniaMOR) {
        MageObjectReference firstOtterMOR = this.playerFirstOtterCast.get(controllerID);
        if (firstOtterMOR != null && firstOtterMOR.equals((Object)AlaniaMOR)) {
            firstOtterMOR = this.playerSecondOtterCast.get(controllerID);
        }
        return spell.equals((Object)this.playerFirstInstantCast.get(controllerID)) || spell.equals((Object)this.playerFirstSorceryCast.get(controllerID)) || spell.equals((Object)firstOtterMOR);
    }
}

