/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import java.util.UUID;
import mage.MageIdentifier;
import mage.abilities.Ability;
import mage.abilities.costs.Costs;
import mage.abilities.costs.CostsImpl;
import mage.abilities.costs.common.DiscardCardCost;
import mage.abilities.costs.mana.ManaCosts;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.effects.AsThoughEffectImpl;
import mage.constants.AsThoughEffectType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class AlienSymbiosisGraveyardEffect
extends AsThoughEffectImpl {
    AlienSymbiosisGraveyardEffect() {
        super(AsThoughEffectType.CAST_FROM_NOT_OWN_HAND_ZONE, Duration.EndOfGame, Outcome.PutCreatureInPlay);
        this.staticText = "You may cast this card from your graveyard by discarding a card in addition to paying its other costs.";
    }

    private AlienSymbiosisGraveyardEffect(AlienSymbiosisGraveyardEffect effect) {
        super((AsThoughEffectImpl)effect);
    }

    public AlienSymbiosisGraveyardEffect copy() {
        return new AlienSymbiosisGraveyardEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        return true;
    }

    public boolean applies(UUID objectId, Ability source, UUID affectedControllerId, Game game) {
        if (!objectId.equals(source.getSourceId()) || !source.isControlledBy(affectedControllerId) || game.getState().getZone(source.getSourceId()) != Zone.GRAVEYARD) {
            return false;
        }
        Player controller = game.getPlayer(affectedControllerId);
        if (controller != null) {
            CostsImpl costs = new CostsImpl();
            costs.add((Object)new DiscardCardCost());
            controller.setCastSourceIdWithAlternateMana(objectId, (ManaCosts)new ManaCostsImpl("{1}{B}"), (Costs)costs, MageIdentifier.AlienSymbiosisAlternateCast);
            return true;
        }
        return false;
    }
}

