/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import java.util.List;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;

class AllIsDustEffect
extends OneShotEffect {
    AllIsDustEffect() {
        super(Outcome.DestroyPermanent);
        this.staticText = "Each player sacrifices all permanents they control that are one or more colors";
    }

    private AllIsDustEffect(AllIsDustEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        List permanents = game.getBattlefield().getActivePermanents(source.getControllerId(), game);
        for (Permanent p : permanents) {
            if (p.getColor(game).isColorless()) continue;
            p.sacrifice(source, game);
        }
        return true;
    }

    public AllIsDustEffect copy() {
        return new AllIsDustEffect(this);
    }
}

