/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.TransformSourceEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;

class AlluringSuitorTriggeredAbility
extends TriggeredAbilityImpl {
    AlluringSuitorTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new TransformSourceEffect());
    }

    private AlluringSuitorTriggeredAbility(AlluringSuitorTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public AlluringSuitorTriggeredAbility copy() {
        return new AlluringSuitorTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DECLARED_ATTACKERS;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean checkTrigger(GameEvent event, Game game) {
        if (!this.isControlledBy(game.getCombat().getAttackingPlayerId())) return false;
        if (game.getCombat().getAttackers().stream().map(arg_0 -> ((Game)game).getPermanent(arg_0)).filter(permanent -> permanent.isCreature(game)).count() != 2L) return false;
        return true;
    }

    public String getRule() {
        return "When you attack with exactly two creatures, transform {this}.";
    }
}

