/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import java.util.Collection;
import java.util.Set;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class AlrundGodOfTheCosmosEffect
extends OneShotEffect {
    AlrundGodOfTheCosmosEffect() {
        super(Outcome.Neutral);
        this.staticText = ", then reveal the top two cards of your library. Put all cards of the chosen type revealed this way into your hand and the rest on the bottom of your library in any order";
    }

    private AlrundGodOfTheCosmosEffect(AlrundGodOfTheCosmosEffect effect) {
        super((OneShotEffect)effect);
    }

    public AlrundGodOfTheCosmosEffect copy() {
        return new AlrundGodOfTheCosmosEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        String chosenCardType = (String)game.getState().getValue(source.getSourceId() + "_type");
        CardsImpl cardsToHand = new CardsImpl();
        CardsImpl cardsToBottomOfLibrary = new CardsImpl();
        if (controller != null) {
            Set twoCardsFromTop = controller.getLibrary().getTopCards(game, 2);
            CardsImpl cards = new CardsImpl();
            cards.addAllCards((Collection)twoCardsFromTop);
            controller.revealCards(source, (Cards)cards, game);
            for (Card card : cards.getCards(game)) {
                if (card.getCardType(game).toString().contains(chosenCardType)) {
                    cardsToHand.add(card);
                    continue;
                }
                cardsToBottomOfLibrary.add(card);
            }
            controller.moveCards((Cards)cardsToHand, Zone.HAND, source, game);
            controller.putCardsOnBottomOfLibrary((Cards)cardsToBottomOfLibrary, game, source, true);
            return true;
        }
        return false;
    }
}

