/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import mage.abilities.Ability;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.common.delayed.AtTheEndOfCombatDelayedTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CreateTokenCopyTargetEffect;
import mage.abilities.effects.common.ExileTargetEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.permanent.PermanentCard;
import mage.target.targetpointer.FixedTargets;
import mage.target.targetpointer.TargetPointer;

class AltairIbnLaAhadTokenEffect
extends OneShotEffect {
    AltairIbnLaAhadTokenEffect() {
        super(Outcome.Benefit);
        this.staticText = "Then for each creature card you own in exile with a memory counter on it, create a tapped and attacking token that's a copy of it. Exile those tokens at end of combat";
    }

    private AltairIbnLaAhadTokenEffect(AltairIbnLaAhadTokenEffect effect) {
        super((OneShotEffect)effect);
    }

    public AltairIbnLaAhadTokenEffect copy() {
        return new AltairIbnLaAhadTokenEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Set cards = game.getExile().getCardsOwned(game, source.getControllerId()).stream().filter(card -> card.getCounters(game).containsKey(CounterType.MEMORY)).filter(card -> card.isCreature(game)).collect(Collectors.toSet());
        if (cards.isEmpty()) {
            return false;
        }
        HashSet permanents = new HashSet();
        for (Card card2 : cards) {
            CreateTokenCopyTargetEffect effect = new CreateTokenCopyTargetEffect(source.getControllerId(), null, false, 1, true, true);
            effect.setSavedPermanent((Permanent)new PermanentCard(card2, source.getControllerId(), game));
            effect.apply(game, source);
            permanents.addAll(effect.getAddedPermanents());
        }
        game.addDelayedTriggeredAbility((DelayedTriggeredAbility)new AtTheEndOfCombatDelayedTriggeredAbility((Effect)new ExileTargetEffect("exile those tokens").setTargetPointer((TargetPointer)new FixedTargets(permanents, game))), source);
        return true;
    }
}

