/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.abilities.Ability;
import mage.abilities.costs.common.SacrificeTargetCost;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class AltarOfTheWretchedEffect
extends OneShotEffect {
    AltarOfTheWretchedEffect() {
        super(Outcome.Benefit);
        this.staticText = "you may sacrifice a nontoken creature. If you do, draw X cards, then mill X cards, where X is that creature's power.";
    }

    private AltarOfTheWretchedEffect(AltarOfTheWretchedEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        SacrificeTargetCost cost;
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null && (cost = new SacrificeTargetCost(1, (FilterPermanent)StaticFilters.FILTER_CONTROLLED_CREATURE_NON_TOKEN)).canPay(source, source, controller.getId(), game) && cost.pay(source, game, source, controller.getId(), true)) {
            int power = ((Permanent)cost.getPermanents().get(0)).getPower().getValue();
            controller.drawCards(power, source, game);
            controller.millCards(power, source, game);
            return true;
        }
        return false;
    }

    public AltarOfTheWretchedEffect copy() {
        return new AltarOfTheWretchedEffect(this);
    }
}

