/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;

class AmassTheComponentsEffect
extends OneShotEffect {
    AmassTheComponentsEffect() {
        super(Outcome.DrawCard);
        this.staticText = "Draw three cards, then put a card from your hand on the bottom of your library";
    }

    private AmassTheComponentsEffect(AmassTheComponentsEffect effect) {
        super((OneShotEffect)effect);
    }

    public AmassTheComponentsEffect copy() {
        return new AmassTheComponentsEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        player.drawCards(3, source, game);
        if (!player.getHand().isEmpty()) {
            Card card;
            FilterCard filter = new FilterCard("card from your hand to put on the bottom of your library");
            TargetCard target = new TargetCard(Zone.HAND, filter);
            if (player.choose(Outcome.Detriment, player.getHand(), target, source, game) && (card = player.getHand().get(target.getFirstTarget(), game)) != null) {
                return player.putCardsOnBottomOfLibrary(card, game, source);
            }
        }
        return true;
    }
}

