/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import java.util.Collection;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.cards.ModalDoubleFacedCard;
import mage.cards.ModalDoubleFacedCardHalf;
import mage.cards.a.AminatousAuguryCastFromExileEffect;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.ExileZone;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;
import mage.util.CardUtil;

class AminatousAuguryEffect
extends OneShotEffect {
    AminatousAuguryEffect() {
        super(Outcome.PlayForFree);
        this.staticText = "Exile the top eight cards of your library. You may put a land card from among them onto the battlefield. Until end of turn, for each nonland card type, you may cast a spell of that type from among the exiled cards without paying its mana cost.";
    }

    private AminatousAuguryEffect(AminatousAuguryEffect effect) {
        super((OneShotEffect)effect);
    }

    public AminatousAuguryEffect copy() {
        return new AminatousAuguryEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Card card;
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        MageObject sourceObject = source.getSourceObject(game);
        if (sourceObject == null) {
            return false;
        }
        controller.moveCardsToExile(controller.getLibrary().getTopCards(game, 8), source, game, true, source.getSourceId(), CardUtil.createObjectRelatedWindowTitle((Ability)source, (Game)game, null));
        ExileZone auguryExileZone = game.getExile().getExileZone(source.getSourceId());
        if (auguryExileZone == null) {
            return true;
        }
        CardsImpl cardsToCast = new CardsImpl();
        cardsToCast.addAllCards((Collection)auguryExileZone.getCards(game));
        TargetCard target = new TargetCard(Zone.EXILED, (FilterCard)StaticFilters.FILTER_CARD_LAND_A);
        if (cardsToCast.count((FilterCard)StaticFilters.FILTER_CARD_LAND, game) > 0 && controller.chooseUse(Outcome.PutLandInPlay, "Put a land from among the exiled cards into play?", source, game) && controller.choose(Outcome.PutLandInPlay, (Cards)cardsToCast, target, source, game) && (card = cardsToCast.get(target.getFirstTarget(), game)) != null) {
            cardsToCast.remove(card);
            controller.moveCards(card, Zone.BATTLEFIELD, source, game, false, false, true, null);
        }
        for (Card card2 : cardsToCast.getCards(game)) {
            if (card2 instanceof ModalDoubleFacedCard) {
                ModalDoubleFacedCardHalf leftHalfCard = ((ModalDoubleFacedCard)card2).getLeftHalfCard();
                if (leftHalfCard == null || leftHalfCard.isLand(game)) continue;
                AminatousAuguryCastFromExileEffect effect = new AminatousAuguryCastFromExileEffect();
                effect.setTargetPointer((TargetPointer)new FixedTarget((Card)leftHalfCard, game));
                game.addEffect((ContinuousEffect)effect, source);
                continue;
            }
            if (card2.isLand(game)) continue;
            AminatousAuguryCastFromExileEffect effect = new AminatousAuguryCastFromExileEffect();
            effect.setTargetPointer((TargetPointer)new FixedTarget(card2, game));
            game.addEffect((ContinuousEffect)effect, source);
        }
        return true;
    }
}

