/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import java.util.Set;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class AmnesiaEffect
extends OneShotEffect {
    AmnesiaEffect() {
        super(Outcome.Discard);
        this.staticText = "Target player reveals their hand and discards all nonland cards";
    }

    private AmnesiaEffect(AmnesiaEffect effect) {
        super((OneShotEffect)effect);
    }

    public AmnesiaEffect copy() {
        return new AmnesiaEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getFirstTarget());
        if (player != null) {
            Cards hand = player.getHand();
            player.revealCards(source, hand, game);
            Set cards = hand.getCards(game);
            cards.removeIf(card -> card.isLand(game));
            player.discard((Cards)new CardsImpl(cards), false, source, game);
            return true;
        }
        return false;
    }
}

