/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import mage.ApprovingObject;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.SpellAbility;
import mage.abilities.costs.Costs;
import mage.abilities.costs.CostsImpl;
import mage.abilities.costs.common.PayEnergyCost;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

class AmpedRaptorEffect
extends OneShotEffect {
    AmpedRaptorEffect() {
        super(Outcome.PlayForFree);
        this.staticText = "exile cards from the top of your library until you exile a nonland card. You may cast that card by paying an amount of {E} equal to its mana value rather than paying its mana cost";
    }

    private AmpedRaptorEffect(AmpedRaptorEffect effect) {
        super((OneShotEffect)effect);
    }

    public AmpedRaptorEffect copy() {
        return new AmpedRaptorEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null || !controller.getLibrary().hasCards()) {
            return false;
        }
        for (Card card : controller.getLibrary().getCards(game)) {
            Card faceCard;
            controller.moveCards(card, Zone.EXILED, source, game);
            if (card.isLand(game)) continue;
            List castableComponents = CardUtil.getCastableComponents((Card)card, null, (Ability)source, (Player)controller, (Game)game, null, (boolean)false);
            if (castableComponents.isEmpty()) break;
            String partsInfo = castableComponents.stream().map(MageObject::getLogName).collect(Collectors.joining(" or "));
            if (!controller.chooseUse(Outcome.PlayForFree, "Cast spell by paying energy instead of mana (" + partsInfo + ")?", source, game)) break;
            castableComponents.forEach(partCard -> {
                Boolean cfr_ignored_0 = (Boolean)game.getState().setValue("PlayFromNotOwnHandZone" + partCard.getId(), (Object)Boolean.TRUE);
            });
            SpellAbility chosenAbility = controller.chooseAbilityForCast(card, game, true);
            if (chosenAbility != null && (faceCard = game.getCard(chosenAbility.getSourceId())) != null) {
                PayEnergyCost energyCost = new PayEnergyCost(faceCard.getManaValue());
                CostsImpl newCosts = new CostsImpl();
                newCosts.add((Object)energyCost);
                newCosts.addAll((Collection)chosenAbility.getCosts());
                controller.setCastSourceIdWithAlternateMana(faceCard.getId(), null, (Costs)newCosts);
                controller.cast(chosenAbility, game, true, new ApprovingObject(source, game));
            }
            castableComponents.forEach(partCard -> game.getState().setValue("PlayFromNotOwnHandZone" + partCard.getId(), null));
            break;
        }
        return true;
    }
}

