/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.abilities.effects.common.TransformSourceEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;
import mage.game.permanent.Permanent;

class AnakinSkywalkerEffect
extends ReplacementEffectImpl {
    AnakinSkywalkerEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Transform);
        this.staticText = "If {this} would die, regenerate and transform him instead";
    }

    private AnakinSkywalkerEffect(AnakinSkywalkerEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        Permanent permanent = game.getPermanent(event.getTargetId());
        if (permanent != null) {
            permanent.regenerate(source, game);
            return new TransformSourceEffect().apply(game, source);
        }
        return false;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ZONE_CHANGE;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        return event.getTargetId().equals(source.getSourceId()) && ((ZoneChangeEvent)event).isDiesEvent();
    }

    public AnakinSkywalkerEffect copy() {
        return new AnakinSkywalkerEffect(this);
    }
}

