/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.DamageEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class AncientAdamantoiseRedirectEffect
extends ReplacementEffectImpl {
    AncientAdamantoiseRedirectEffect() {
        super(Duration.WhileOnBattlefield, Outcome.RedirectDamage);
        this.staticText = "all damage that would be dealt to you and other permanents you control is dealt to this creature instead";
    }

    private AncientAdamantoiseRedirectEffect(AncientAdamantoiseRedirectEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public AncientAdamantoiseRedirectEffect copy() {
        return new AncientAdamantoiseRedirectEffect(this);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        DamageEvent damageEvent = (DamageEvent)event;
        Permanent permanent = source.getSourcePermanentOrLKI(game);
        if (permanent != null) {
            permanent.damage(damageEvent.getAmount(), event.getSourceId(), source, game, damageEvent.isCombatDamage(), damageEvent.isPreventable());
        }
        return true;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        switch (event.getType()) {
            case DAMAGE_PLAYER: 
            case DAMAGE_PERMANENT: {
                return true;
            }
        }
        return false;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        switch (event.getType()) {
            case DAMAGE_PLAYER: {
                return source.isControlledBy(event.getTargetId());
            }
            case DAMAGE_PERMANENT: {
                return !event.getTargetId().equals(source.getSourceId()) && source.isControlledBy(game.getControllerId(event.getTargetId()));
            }
        }
        return false;
    }
}

