/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.abilities.Ability;
import mage.abilities.dynamicvalue.common.CardsInControllerHandCount;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class AncientExcavationEffect
extends OneShotEffect {
    AncientExcavationEffect() {
        super(Outcome.DrawCard);
        this.staticText = "Draw cards equal to the number of cards in your hand, then discard a card for each card drawn this way";
    }

    private AncientExcavationEffect(AncientExcavationEffect effect) {
        super((OneShotEffect)effect);
    }

    public AncientExcavationEffect copy() {
        return new AncientExcavationEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player != null) {
            CardsInControllerHandCount numCards = CardsInControllerHandCount.ANY;
            int amount = numCards.calculate(game, source, (Effect)this);
            int cardsDrawn = player.drawCards(amount, source, game);
            player.discard(cardsDrawn, false, false, source, game);
            return true;
        }
        return false;
    }
}

