/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.common.DiesAttachedTriggeredAbility;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.AttachEffect;
import mage.abilities.effects.common.ReturnToHandSourceEffect;
import mage.abilities.effects.common.continuous.AddCardSubtypeAttachedEffect;
import mage.abilities.effects.common.continuous.BoostEnchantedEffect;
import mage.abilities.effects.common.continuous.GainAbilityAttachedEffect;
import mage.abilities.keyword.EnchantAbility;
import mage.abilities.keyword.FirstStrikeAbility;
import mage.abilities.keyword.FlyingAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.AttachmentType;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.target.Target;
import mage.target.common.TargetCreaturePermanent;

public final class AngelicDestiny
extends CardImpl {
    public AngelicDestiny(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.ENCHANTMENT}, "{2}{W}{W}");
        this.subtype.add((Object)SubType.AURA);
        TargetCreaturePermanent auraTarget = new TargetCreaturePermanent();
        this.getSpellAbility().addTarget((Target)auraTarget);
        this.getSpellAbility().addEffect((Effect)new AttachEffect(Outcome.BoostCreature));
        EnchantAbility ability = new EnchantAbility((Target)auraTarget);
        this.addAbility((Ability)ability);
        ability = new SimpleStaticAbility((Effect)new BoostEnchantedEffect(4, 4, Duration.WhileOnBattlefield));
        GainAbilityAttachedEffect effect = new GainAbilityAttachedEffect((Ability)FlyingAbility.getInstance(), AttachmentType.AURA);
        effect.setText(", has flying");
        ability.addEffect((Effect)effect);
        effect = new GainAbilityAttachedEffect((Ability)FirstStrikeAbility.getInstance(), AttachmentType.AURA);
        effect.setText("and first strike");
        ability.addEffect((Effect)effect);
        effect = new AddCardSubtypeAttachedEffect(SubType.ANGEL, AttachmentType.AURA);
        effect.setText(", and is an Angel in addition to its other types");
        ability.addEffect((Effect)effect);
        this.addAbility((Ability)ability);
        this.addAbility((Ability)new DiesAttachedTriggeredAbility((Effect)new ReturnToHandSourceEffect(false, true), "enchanted creature"));
    }

    private AngelicDestiny(AngelicDestiny card) {
        super((CardImpl)card);
    }

    public AngelicDestiny copy() {
        return new AngelicDestiny(this);
    }
}

