/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class AngrathTheFlameUltimateEffect
extends OneShotEffect {
    AngrathTheFlameUltimateEffect() {
        super(Outcome.Benefit);
        this.staticText = "Each opponent loses life equal to the number of cards in their graveyard";
    }

    private AngrathTheFlameUltimateEffect(AngrathTheFlameUltimateEffect effect) {
        super((OneShotEffect)effect);
    }

    public AngrathTheFlameUltimateEffect copy() {
        return new AngrathTheFlameUltimateEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        for (UUID opponentId : game.getOpponents(source.getControllerId())) {
            Player player = game.getPlayer(opponentId);
            if (player == null || player.getGraveyard().isEmpty()) continue;
            player.loseLife(player.getGraveyard().size(), game, source, false);
        }
        return true;
    }
}

