/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import java.util.List;
import java.util.UUID;
import mage.MageObject;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CreateTokenEffect;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.permanent.token.SquirrelToken;
import mage.game.permanent.token.Token;

class AnimalFriendTokenEffect
extends OneShotEffect {
    MageObjectReference aura;

    AnimalFriendTokenEffect(MageObjectReference aura, String name) {
        super(Outcome.PutCreatureInPlay);
        this.aura = aura;
        this.staticText = "create a 1/1 green Squirrel creature token. Put a +1/+1 counter on that token for each Aura and Equipment attached to this creature other than " + name;
    }

    private AnimalFriendTokenEffect(AnimalFriendTokenEffect effect) {
        super((OneShotEffect)effect);
        this.aura = effect.aura;
    }

    public AnimalFriendTokenEffect copy() {
        return new AnimalFriendTokenEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        CreateTokenEffect effect = new CreateTokenEffect((Token)new SquirrelToken());
        if (!effect.apply(game, source)) {
            return false;
        }
        Permanent p = source.getSourcePermanentIfItStillExists(game);
        int xValue = 0;
        if (p != null) {
            List attachments = p.getAttachments();
            for (UUID attachmentId : attachments) {
                Permanent attached = game.getPermanent(attachmentId);
                if (attached == null || !attached.hasSubtype(SubType.AURA, game) && !attached.hasSubtype(SubType.EQUIPMENT, game) || this.aura.refersTo((MageObject)attached, game)) continue;
                ++xValue;
            }
        }
        if (xValue <= 0) {
            return true;
        }
        for (UUID id : effect.getLastAddedTokenIds()) {
            Permanent token = game.getPermanent(id);
            if (token == null) continue;
            token.addCounters(CounterType.P1P1.createInstance(xValue), source.getControllerId(), source, game);
        }
        return true;
    }
}

