/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.cards.a.ApexObservatoryCastWithoutManaEffect;
import mage.constants.Outcome;
import mage.game.Game;

class ApexObservatoryEffect
extends OneShotEffect {
    ApexObservatoryEffect() {
        super(Outcome.Benefit);
        this.staticText = "The next spell you cast this turn of the chosen type can be cast without paying its mana cost.";
    }

    private ApexObservatoryEffect(ApexObservatoryEffect effect) {
        super((OneShotEffect)effect);
    }

    public ApexObservatoryEffect copy() {
        return new ApexObservatoryEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        String chosenCardType = (String)game.getState().getValue("ApexObservatoryType_" + source.getSourceId().toString());
        if (chosenCardType == null) {
            return false;
        }
        game.addEffect((ContinuousEffect)new ApexObservatoryCastWithoutManaEffect(chosenCardType, source.getControllerId()), source);
        return true;
    }
}

