/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import java.util.Set;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.asthought.PlayFromNotOwnHandZoneTargetEffect;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class ApexOfPowerSpellEffect
extends OneShotEffect {
    ApexOfPowerSpellEffect() {
        super(Outcome.Benefit);
        this.staticText = "exile the top seven cards of your library. Until end of turn, you may cast spells from among them";
    }

    private ApexOfPowerSpellEffect(ApexOfPowerSpellEffect effect) {
        super((OneShotEffect)effect);
    }

    public ApexOfPowerSpellEffect copy() {
        return new ApexOfPowerSpellEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        MageObject sourceObject = source.getSourceObject(game);
        if (controller == null || sourceObject == null) {
            return false;
        }
        Set cards = controller.getLibrary().getTopCards(game, 7);
        if (cards.isEmpty()) {
            return false;
        }
        controller.moveCards(cards, Zone.EXILED, source, game);
        for (Card card : cards) {
            if (card.isLand(game)) continue;
            PlayFromNotOwnHandZoneTargetEffect effect = new PlayFromNotOwnHandZoneTargetEffect(Zone.EXILED, Duration.EndOfTurn);
            effect.setTargetPointer((TargetPointer)new FixedTarget(card, game));
            game.addEffect((ContinuousEffect)effect, source);
        }
        return true;
    }
}

