/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import mage.MageInt;
import mage.abilities.Ability;
import mage.abilities.common.AsEntersBattlefieldAbility;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotNonTargetEffect;
import mage.abilities.effects.common.ChooseCardTypeEffect;
import mage.abilities.effects.common.LookAtTargetPlayerHandEffect;
import mage.abilities.effects.common.cost.SpellsCostIncreasingAllEffect;
import mage.abilities.keyword.WebSlingingAbility;
import mage.cards.Card;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.constants.SuperType;
import mage.constants.TargetController;
import mage.filter.FilterCard;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.filter.predicate.mageobject.ChosenCardTypePredicate;
import mage.target.Target;
import mage.target.common.TargetOpponent;

public final class ArachnePsionicWeaver
extends CardImpl {
    private static final FilterCard filter = new FilterCard("spells of the chosen type");

    public ArachnePsionicWeaver(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.CREATURE}, "{2}{W}");
        this.supertype.add(SuperType.LEGENDARY);
        this.subtype.add((Object)SubType.SPIDER);
        this.subtype.add((Object)SubType.HUMAN);
        this.subtype.add((Object)SubType.HERO);
        this.power = new MageInt(3);
        this.toughness = new MageInt(3);
        this.addAbility((Ability)new WebSlingingAbility((Card)this, "{W}"));
        List types = Arrays.stream(CardType.values()).filter(cardType -> cardType != CardType.CREATURE).collect(Collectors.toList());
        AsEntersBattlefieldAbility ability = new AsEntersBattlefieldAbility((Effect)new OneShotNonTargetEffect(new LookAtTargetPlayerHandEffect().setText("look at an opponent's hand"), (Target)new TargetOpponent()));
        ability.addEffect((Effect)new ChooseCardTypeEffect(Outcome.Benefit, types).setText("choose a card type other than creature").concatBy(", then"));
        this.addAbility((Ability)ability);
        this.addAbility((Ability)new SimpleStaticAbility((Effect)new SpellsCostIncreasingAllEffect(1, filter, TargetController.ANY)));
    }

    private ArachnePsionicWeaver(ArachnePsionicWeaver card) {
        super((CardImpl)card);
    }

    public ArachnePsionicWeaver copy() {
        return new ArachnePsionicWeaver(this);
    }

    static {
        filter.add((ObjectSourcePlayerPredicate)ChosenCardTypePredicate.TRUE);
    }
}

