/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.BoostTargetEffect;
import mage.abilities.effects.common.continuous.GainAbilityTargetEffect;
import mage.abilities.keyword.TrampleAbility;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class ArahboEffect
extends OneShotEffect {
    ArahboEffect() {
        super(Outcome.Benefit);
        this.staticText = "it gains trample and gets +X/+X until end of turn, where X is its power";
    }

    private ArahboEffect(ArahboEffect effect) {
        super((OneShotEffect)effect);
    }

    public ArahboEffect copy() {
        return new ArahboEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent creature = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (creature != null && creature.isCreature(game)) {
            int pow = creature.getPower().getValue();
            BoostTargetEffect effect = new BoostTargetEffect(pow, pow, Duration.EndOfTurn);
            effect.setTargetPointer((TargetPointer)new FixedTarget(creature, game));
            game.addEffect((ContinuousEffect)effect, source);
            effect = new GainAbilityTargetEffect((Ability)TrampleAbility.getInstance(), Duration.EndOfTurn);
            effect.setTargetPointer((TargetPointer)new FixedTarget(creature, game));
            game.addEffect((ContinuousEffect)effect, source);
        }
        return true;
    }
}

