/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.abilities.Ability;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.constants.Zone;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.permanent.BlockingPredicate;
import mage.game.Game;
import mage.game.events.DamagedEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class ArashinWarBeastTriggeredAbility
extends TriggeredAbilityImpl {
    private static final FilterCreaturePermanent filter = new FilterCreaturePermanent("one or more blockers");
    boolean usedForCombatDamageStep;

    public ArashinWarBeastTriggeredAbility(Effect effect, boolean optional) {
        super(Zone.BATTLEFIELD, effect, optional);
        this.usedForCombatDamageStep = false;
        this.setTriggerPhrase("Whenever {this} deals combat damage to one or more blocking creatures, ");
    }

    private ArashinWarBeastTriggeredAbility(ArashinWarBeastTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
        this.usedForCombatDamageStep = ability.usedForCombatDamageStep;
    }

    public ArashinWarBeastTriggeredAbility copy() {
        return new ArashinWarBeastTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DAMAGED_PERMANENT || event.getType() == GameEvent.EventType.COMBAT_DAMAGE_STEP_POST;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        if (event.getType() == GameEvent.EventType.DAMAGED_PERMANENT && event.getSourceId().equals(this.sourceId) && ((DamagedEvent)event).isCombatDamage() && !this.usedForCombatDamageStep) {
            Permanent creature = game.getPermanentOrLKIBattlefield(event.getTargetId());
            if (creature == null || !filter.match(creature, this.getControllerId(), (Ability)this, game)) {
                return false;
            }
            this.usedForCombatDamageStep = true;
            return true;
        }
        if (event.getType() == GameEvent.EventType.COMBAT_DAMAGE_STEP_POST) {
            this.usedForCombatDamageStep = false;
        }
        return false;
    }

    static {
        filter.add((Predicate)BlockingPredicate.instance);
    }
}

