/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.AddCardTypeTargetEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;
import mage.util.CardUtil;

class ArbiterOfTheIdealEffect
extends OneShotEffect {
    private static final FilterCard filter = new FilterCard();

    public ArbiterOfTheIdealEffect() {
        super(Outcome.PutCardInPlay);
        this.staticText = "reveal the top card of your library. If it's an artifact, creature, or land card, you may put it onto the battlefield with a manifestation counter on it. It's an enchantment in addition to its other types";
    }

    private ArbiterOfTheIdealEffect(ArbiterOfTheIdealEffect effect) {
        super((OneShotEffect)effect);
    }

    public ArbiterOfTheIdealEffect copy() {
        return new ArbiterOfTheIdealEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        MageObject sourceObject = source.getSourceObject(game);
        if (controller == null || sourceObject == null) {
            return false;
        }
        Card card = controller.getLibrary().getFromTop(game);
        if (card != null) {
            controller.revealCards(sourceObject.getIdName(), (Cards)new CardsImpl(card), game);
            if (filter.match(card, game) && controller.chooseUse(this.outcome, "Put " + card.getName() + " onto the battlefield?", source, game)) {
                controller.moveCards(card, Zone.BATTLEFIELD, source, game);
                Permanent permanent = CardUtil.getPermanentFromCardPutToBattlefield((Card)card, (Game)game);
                if (permanent != null) {
                    permanent.addCounters(CounterType.MANIFESTATION.createInstance(), source.getControllerId(), source, game);
                    AddCardTypeTargetEffect effect = new AddCardTypeTargetEffect(Duration.Custom, new CardType[]{CardType.ENCHANTMENT});
                    effect.setTargetPointer((TargetPointer)new FixedTarget(permanent, game));
                    game.addEffect((ContinuousEffect)effect, source);
                }
            }
        }
        return true;
    }

    static {
        filter.add(Predicates.or((Predicate[])new Predicate[]{CardType.ARTIFACT.getPredicate(), CardType.CREATURE.getPredicate(), CardType.LAND.getPredicate()}));
    }
}

