/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.common.delayed.AtTheBeginOfNextUpkeepDelayedTriggeredAbility;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.dynamicvalue.common.StaticValue;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.DrawCardTargetEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class ArcaneDenialEffect
extends OneShotEffect {
    ArcaneDenialEffect() {
        super(Outcome.Detriment);
        this.staticText = "Counter target spell. Its controller may draw up to two cards at the beginning of the next turn's upkeep";
    }

    private ArcaneDenialEffect(ArcaneDenialEffect effect) {
        super((OneShotEffect)effect);
    }

    public ArcaneDenialEffect copy() {
        return new ArcaneDenialEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = null;
        boolean countered = false;
        UUID targetId = this.getTargetPointer().getFirst(game, source);
        if (targetId != null) {
            controller = game.getPlayer(game.getControllerId(targetId));
        }
        if (targetId != null && game.getStack().counter(targetId, source, game)) {
            countered = true;
        }
        if (controller != null) {
            DrawCardTargetEffect effect = new DrawCardTargetEffect((DynamicValue)StaticValue.get((int)2), false, true);
            effect.setTargetPointer((TargetPointer)new FixedTarget(controller.getId()));
            effect.setText("Its controller may draw up to two cards");
            AtTheBeginOfNextUpkeepDelayedTriggeredAbility ability = new AtTheBeginOfNextUpkeepDelayedTriggeredAbility((Effect)effect);
            game.addDelayedTriggeredAbility((DelayedTriggeredAbility)ability, source);
        }
        return countered;
    }
}

