/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.SearchEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.game.Game;
import mage.players.Player;
import mage.target.common.TargetCardInLibrary;
import mage.util.CardUtil;

class ArchdruidsCharmMode1Effect
extends SearchEffect {
    private final boolean revealCards;
    private final FilterCard putOnBattlefieldFilter;

    public ArchdruidsCharmMode1Effect(TargetCardInLibrary target, boolean revealCards, FilterCard putOnBattlefieldFilter) {
        super(target, Outcome.DrawCard);
        this.revealCards = revealCards;
        this.putOnBattlefieldFilter = putOnBattlefieldFilter;
        this.setText();
    }

    protected ArchdruidsCharmMode1Effect(ArchdruidsCharmMode1Effect effect) {
        super((SearchEffect)effect);
        this.revealCards = effect.revealCards;
        this.putOnBattlefieldFilter = effect.putOnBattlefieldFilter;
    }

    public ArchdruidsCharmMode1Effect copy() {
        return new ArchdruidsCharmMode1Effect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        this.target.clearChosen();
        boolean searchSuccessful = false;
        if (controller.searchLibrary(this.target, source, game)) {
            if (!this.target.getTargets().isEmpty()) {
                CardsImpl cards = new CardsImpl();
                for (UUID cardId : this.target.getTargets()) {
                    Card card = game.getCard(cardId);
                    if (card == null) continue;
                    if (this.putOnBattlefieldFilter.match(card, game)) {
                        controller.moveCards(card, Zone.BATTLEFIELD, source, game, true, false, false, null);
                    } else {
                        controller.moveCards(card, Zone.HAND, source, game);
                    }
                    cards.add(card);
                }
                if (this.revealCards) {
                    String name = "Reveal";
                    Card sourceCard = game.getCard(source.getSourceId());
                    if (sourceCard != null) {
                        name = sourceCard.getIdName();
                    }
                    controller.revealCards(name, (Cards)cards, game);
                }
            }
            searchSuccessful = true;
        }
        controller.shuffleLibrary(source, game);
        return searchSuccessful;
    }

    private void setText() {
        StringBuilder sb = new StringBuilder();
        sb.append("Search your library for ");
        if (this.target.getMinNumberOfTargets() == 0 && this.target.getMaxNumberOfTargets() > 0) {
            sb.append("up to ").append(CardUtil.numberToText((int)this.target.getMaxNumberOfTargets())).append(' ');
            sb.append(this.target.getTargetName()).append(this.revealCards ? " and reveal them." : ".");
        } else {
            sb.append("a ").append(this.target.getTargetName()).append(this.revealCards ? " and reveal it." : ".");
        }
        if (this.putOnBattlefieldFilter != null) {
            sb.append(" Put it onto the battlefield tapped if it's a ");
            sb.append(this.putOnBattlefieldFilter.getMessage());
            sb.append(". Otherwise, put it into your hand.");
        }
        sb.append(" Then shuffle.");
        this.staticText = sb.toString();
    }
}

