/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.abilities.Ability;
import mage.abilities.common.SimpleActivatedAbility;
import mage.abilities.costs.Cost;
import mage.abilities.costs.common.TapSourceCost;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DamageTargetEffect;
import mage.cards.a.ArcheryTrainingValue;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.Target;
import mage.target.common.TargetAttackingOrBlockingCreature;

class ArcheryTrainingEffect
extends ContinuousEffectImpl {
    ArcheryTrainingEffect() {
        super(Duration.WhileOnBattlefield, Layer.AbilityAddingRemovingEffects_6, SubLayer.NA, Outcome.Benefit);
        this.staticText = "enchanted creature has \"{T}: This creature deals X damage to target attacking or blocking creature, where X is the number of arrow counters on {this}.\"";
    }

    private ArcheryTrainingEffect(ArcheryTrainingEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public ArcheryTrainingEffect copy() {
        return new ArcheryTrainingEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent aura = game.getPermanent(source.getSourceId());
        if (aura == null) {
            return false;
        }
        Permanent permanent = game.getPermanent(aura.getAttachedTo());
        if (permanent == null) {
            return false;
        }
        String rule = "this creature deals X damage to target attacking or blocking creature, where X is the number of arrow counters on " + aura.getName();
        SimpleActivatedAbility ability = new SimpleActivatedAbility((Effect)new DamageTargetEffect((DynamicValue)new ArcheryTrainingValue(aura)).setText(rule), (Cost)new TapSourceCost());
        ability.addTarget((Target)new TargetAttackingOrBlockingCreature());
        permanent.addAbility((Ability)ability, source.getSourceId(), game);
        return true;
    }
}

